const path = require('path')
const webpack = require('webpack')
const MiniCssExtractPlugin = require('mini-css-extract-plugin')
const { CleanWebpackPlugin } = require('clean-webpack-plugin')
const CopyWebpackPlugin = require('copy-webpack-plugin')


module.exports = {
    entry: {
        dashboard: './src/js/dashboard.js',
        main: './src/js/main.js' // used for the frontend
    },
    output: {
        filename: 'js/[name].bundle.js',
        path: path.resolve(__dirname, 'dist/'),
        //publicPath: 'assets/'
    },
    mode: 'development',
    devtool: 'source-map',
    module: {
        rules: [
            {
               test: /\.js$/,
               exclude: /node_modules/,
               use: {
                   loader: 'babel-loader',
                   options: {
                       presets: ['@babel/env'],
                       plugins: ['transform-class-properties']
                   }
               }
            },
            {
                test: /\.css$/,
                use: [MiniCssExtractPlugin.loader, 'css-loader']
            },
            {
                test: /\.(sass|scss)$/,
                use: [MiniCssExtractPlugin.loader, 'css-loader', 'sass-loader']
            },
            {
                test: /\.(jpg|png|jpeg|svg|gif)$/,
                type: 'asset/resource',
                generator: {
                    filename: 'imgs/[name][ext]'
                }
            },
            {
                test: /\.(ttf|eot|woff|woff2)(\?.*)?$/,
                type: 'asset/resource',
                generator: {
                    filename: 'fonts/[name][ext]'
                }
            },
        ],
    },
    plugins: [
        new webpack.ProvidePlugin({
            $: 'jquery',
            jQuery: 'jquery',
            'window.jQuery': 'jquery'
        }),
        new MiniCssExtractPlugin({
            filename: 'css/[name].bundle.css'
        }),
        new CleanWebpackPlugin({
            dangerouslyAllowCleanPatternsOutsideProject: true,
            dry: false,
            verbose: true,
            cleanOnceBeforeBuildPatterns: [
                '**/*',
                `${__dirname}/../app/static/**/*`,
            ],
        }),
        new CopyWebpackPlugin({
            patterns: [
                { from: 'src/imgs/', to: path.resolve(__dirname, 'dist/imgs/'), force: true},
                { from: 'dist/', to: path.resolve(__dirname, '../app/static/') },
            ]
        })
    ]
}
